package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="locationdocument", propOrder={
		"id",
		"locationName",
		"uploaded",
		"documents"
		})
public class RequestLocationDocumentView implements Comparable {
	private String locationName;
	
	private String id;	//for group-based documents: need a different ID to key off of (need something unique for each group and each location)
	
	private boolean uploaded = false;
	
	@XmlElement(name="document")
	private List<DocumentView> documents = new ArrayList<DocumentView>();
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}	
	
	public String getLocationName() {
		return locationName;
	}

	public void setLocationName(String locationName) {
		this.locationName = locationName;
	}	
	
	public List<DocumentView> getDocuments() {
		return documents;
	}
	
	public boolean isUploaded() {
		return uploaded;
	}

	public void setUploaded(boolean uploaded) {
		this.uploaded = uploaded;
	}

	
	/**
	 * Sort based on the locationName (primary site first)
	 */
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		
		if( locationName == null ) {
			return -1;
		}
		if( locationName != null && locationName.contains("Primary Site")) {	//primary site at the top
			return -1;
		}

		return locationName.compareTo(((RequestLocationDocumentView)o).locationName);
	}
	
}
